<?
	// Include the session configuration file
	include('includes/session.inc');
	
	// Verify that the username and password are set, and if they are
	// include the database and function files, and show the contents of the page
	if(isset($username) && isset($password)){

		// Ensure the $full_date and $full_date_formatted variables are set,
		// and set them if they are not
		if(!IsSet($full_date)){
			$full_date = date("Ymd");
		}
		
		if(!IsSet($full_date_formatted)){
			$full_date_formatted = date("m/d/Y");
		}

        	include('includes/config.inc');
        	include('includes/db.inc');
        	include('includes/queries.inc');
        	include('includes/functions.inc');
        	
        	// Check to see if a request to add a new appointment
        	// was sent
        	if($appointment_add_submit){
        		// Let's check the form for errors. Let's make sure that the user has
        		// entered a title, description, start time, and end time
        		// Check the title field
        		if(empty($appt_title_add)){
        			$title_error = "You must enter a title";
        		}
        		
        		// Check the description field
        		if(empty($appt_description_add)){
	        		$description_error = "you must enter a description";
        		}
        		
        		// Check the start time field
        		if(empty($appt_start_add)){
	        		$start_time_error = "you must enter a start time";
        		}
        		// Check the start time field
        		if(empty($appt_end_add)){
	        		$end_time_error = "you must enter an end time";
        		}
        		else{
        			// Pull the hour out of the start and end times
        			$appt_start_hour = substr($appt_start_add,0,2);
        			$appt_end_hour = substr($appt_end_add,0,2);
        			
        			// Check to make sure the end time is greater than or equal
        			// to the start time
        			if($appt_end_hour <= $appt_start_hour){
        				$end_time_error = "end times must be later than start times";
        			}
        		}
        		
        		// Next, let's go ahead and submit the values entered to the database unless there
        		// were errors.
        		if((!IsSet($title_error)) && (!IsSet($description_error)) && (!IsSet($start_time_error)) && (!IsSet($end_time_error))){
        			// Add the appointment to the database
        			mysql_query($appointment_add) or die(mysql_error());
        		
        			// Uncomment the following line if you want to be taken back to the daily appointment list
        			// after submitting a new appointment
        			header("Location:appointments.php?view=day&full_date=".$appt_day_add."&full_date_formatted=".$full_date_formatted."");
        		}
        		// In the case of errors, we will skip submitting the data and go back
        		// to the form with the for values echoed
        		else{
        			$message = "There were errors detected. Check the form for details";
        		}
        	}

        	// Check to see if a request to go back to the appointments
        	// was sent
        	if($back_to_appointments){
        		header("Location:appointments.php?view=month&full_date=".$full_date."&full_date_formatted=".$full_date_formatted."");
        	}
	
        	// Build an array of time for the start time and end time
        	$time_array[0] = array("000000","12:00 AM");
        	$time_array[1] = array("010000","01:00 AM");
        	$time_array[2] = array("020000","02:00 AM");
        	$time_array[3] = array("030000","03:00 AM");
        	$time_array[4] = array("040000","04:00 AM");
        	$time_array[5] = array("050000","05:00 AM");
        	$time_array[6] = array("060000","06:00 AM");
        	$time_array[7] = array("070000","07:00 AM");
        	$time_array[8] = array("080000","08:00 AM");
        	$time_array[9] = array("090000","09:00 AM");
        	$time_array[10] = array("100000","10:00 AM");
        	$time_array[11] = array("110000","11:00 AM");
        	$time_array[12] = array("120000","12:00 PM");
        	$time_array[13] = array("130000","01:00 PM");
        	$time_array[14] = array("140000","02:00 PM");
        	$time_array[15] = array("150000","03:00 PM");
        	$time_array[16] = array("160000","04:00 PM");
        	$time_array[17] = array("170000","05:00 PM");
        	$time_array[18] = array("180000","06:00 PM");
        	$time_array[19] = array("190000","07:00 PM");
        	$time_array[20] = array("200000","08:00 PM");
        	$time_array[21] = array("210000","09:00 PM");
        	$time_array[22] = array("220000","10:00 PM");
        	$time_array[23] = array("230000","11:00 PM");
        		
        
        ////////////////////////////
        // BEGIN HEADER INCLUSION //
        ////////////////////////////
        	
        	include('includes/header.inc');
        	
        ?>
            <br>
            <p align="center"><b><font size="4">Create New Appointment</font></b><br>
            	<?
            		if(!empty($message)){
            			echo "<div align=\"center\" class=\"error_text\">(".$message.")</div>";
            		}
            	?>
            </p>
        
        <!-- BEGIN CONTENT -->
        
              <form name="appointment_add_form" method="POST" action="appointment_add.php">
              <table width="400" cellpadding="0" cellspacing="0" border="0" class="list_table">
                <tr>
                  <td class="header_cell">&nbsp;</td>
                </tr>
                <tr>
                  <td class="content_cell">
                    <div align="center">
                    <table width="350" cellpadding="5" cellspacing="0" border="0">
                      <tr>
                        <td>
                          <table width="100%" cellpadding="0" cellspacing="0" border="0">
                            <tr>
                              <td>
                                <div align="left">Appointment Date:</div>
                              </td>
                              <td>
                                <div align="right"><b><?= $full_date_formatted; ?></b></div>
                              </td>
                            </tr>
                          </table>
                        </td>
                      </tr>
                      <tr>
                        <td valign="top">
                          <div align="left">Start Time:</div>
                          <div align="left">
                            <select name="appt_start_add">
                              <option value="">-- Start --</option>
                              
                              <?
                              	for($i = 0;$i < sizeof($time_array);$i++){
                              		if($time_array[$i][0] == $appt_start_add){
                              			echo "<option value=\"".$time_array[$i][0]."\" SELECTED>".$time_array[$i][1]."</option>\n";
                              		}
                              		else{
                              			echo "<option value=\"".$time_array[$i][0]."\">".$time_array[$i][1]."</option>\n";
                              		}
                              	}
                              ?>
                              
                            </select>
                          </div>
                          
                          <?
                          	// Print out an error is there was no first name entered
                          	if(IsSet($start_time_error)){
                          		echo "<div align=\"left\" class=\"error_text\">
                          			<b>*</b>".$start_time_error."
                          		      </div>";
                          	}
                          ?>
                          
                        </td>
                        <td valign="top">
                          <div align="left">End Time:</div>
                          <div align="left">
                            <select name="appt_end_add">
                              <option value="">-- End --</option>
                              
                              <?
                              	for($i = 0;$i < sizeof($time_array);$i++){
                              		if($time_array[$i][0] == $appt_end_add){
                              			echo "<option value=\"".$time_array[$i][0]."\" SELECTED>".$time_array[$i][1]."</option>\n";
                              		}
                              		else{
                              			echo "<option value=\"".$time_array[$i][0]."\">".$time_array[$i][1]."</option>\n";
                              		}
                              	}
                              ?>
                              
                            </select>
                          </div>
                          
                          <?
                          	// Print out an error is there was no first name entered
                          	if(IsSet($end_time_error)){
                          		echo "<div align=\"left\" class=\"error_text\">
                          			<b>*</b>".$end_time_error."
                          		      </div>";
                          	}
                          ?>
                          
                        </td>
                      </tr>
                      <tr>
                        <td colspan="2">
                          <div align="left">Title:</div>
                          <div align="left">
                          <input type="text" name="appt_title_add" value="<?= $appt_title_add; ?>" size="45" maxlength="100">
                          </div>
                          	
                          	<?
                          		if(IsSet($title_error)){
                          			echo "<div align=\"left\" class=\"error_text\">
                          				<b>*</b>".$title_error."
                          		      	      </div>";
                          		}
                          	?>
                          	
                        </td>
                      </tr>
                      <tr>
                        <td colspan="2">
                          <div align="left">Description:</div>
                          <div align="left">
                          <textarea name="appt_description_add" cols="34" rows="10"><?= $appt_description_add; ?></textarea>
                          </div>
                          
                          	<?
                          		if(IsSet($description_error)){
                          			echo "<div align=\"left\" class=\"error_text\">
                          				<b>*</b>".$description_error."
                          		      	      </div>";
                          		}
                          	?>
                          	
                        </td>
              	    </table>
              	  </td>
              	</tr>
              	<tr>
                  <td class="footer_cell">&nbsp;</td>
                </tr>
                <tr>
                  <td>
                    <br>
                    <table width="100%" cellpadding="0" cellspacing="0" border="0">
                      <tr>
                        <td>
                          <div align="left">
                            <input type="hidden" name="appt_day_add" value="<?= $full_date; ?>">
                            <input type="hidden" name="full_date" value="<?= $full_date; ?>">
                            <input type="hidden" name="full_date_formatted" value="<?= $full_date_formatted; ?>">
                            <input type="submit" name="back_to_appointments" value="Back to Appointments">
                    	  </div>
                        <td>
                    	  <div align="right">
                            <input type="submit" name="appointment_add_submit" value="Add Appointment">
                    	  </div>
                  	</td>
                      </tr>
                    </table>
                  </td>
                </tr>
              </table>
              </form>    
        
        <!-- END CONTENT -->
        
              <br>
<?
		include('includes/footer.inc');
	}
	else{
		header("Location:index.php");
	}		
?>