<?php
# initialise variables
$username = $firstname = $lastname = $email = "";
$data = array();
$changed = false;

# define your data file and its path, ensure you have write permission to folder
$myTextFile = 'data/mydata.txt';

# get the data from current file
    if (file_exists($myTextFile))
        $data = parse_ini_file($myTextFile, true);


# check if user data form submitted
if (isset($_POST['userdata'])) {
	if (!empty($_POST['username']) && !empty($_POST['email']) ) {
        # add new data (or update if exists already)
        $data[$_POST['username']]['firstname'] = $_POST['firstname'];
        $data[$_POST['username']]['lastname'] = $_POST['lastname'];
        $data[$_POST['username']]['email'] = $_POST['email'];
    
        $changed = true;
	}
	else echo "<p>Must have username and email</p>";
}

# do we want to delete a record
if (isset($_GET['delid'])) {

    # remove deleted item from the array
    unset($data[$_GET['delid']]);
    $changed = true;
}

# or do we want to edit a record
if (isset($_GET['changeid'])) {
        # get the items we want to edit so they can appear in the form
        $username = $_GET['changeid'];
        $firstname = $data[$username]['firstname'];
        $lastname = $data[$username]['lastname'];
        $email = $data[$username]['email'];
}

if ($changed) {
    # now create new output file, writing in ini file format
    $fp = fopen($myTextFile, 'w');

    ksort($data);
    foreach ($data as $key=>$dataArray) {
             fwrite($fp, "[$key]\n");
             foreach ($dataArray as $k => $v) {
                      fwrite($fp, "$k=$v\n");
             }
             fwrite($fp, "\n");
    }
    fclose($fp);
}

# function to list the current data
function listData($data) {
         if (count($data) > 0) {
             echo "<TABLE border='0' cellspacing='1' cellpadding='2'>\n";
             # headings
             echo "<tr style='background: #C0C0C0'><th>ID</th>";
             list ( $key, $dataArray) = each($data);
             foreach($dataArray as $k=>$v) {
                     echo "<th>$k</th>";
             }
             echo "<th>Del</th></tr>";

             #data
             $i = 0;
             foreach ($data as $key=>$dataArray) {
                     $bg = ++$i % 2 ? "#FFFFFF" : "#EEEEEE";
                     echo "<tr style='background: $bg'>
                            <td>
                            <a href='$_SERVER[PHP_SELF]?changeid=$key'>$key<a>
                            </td>";
                     foreach ($dataArray as $v) {
                               echo "<td>$v</td>";
                     }
                     echo "<td>[<a href='$_SERVER[PHP_SELF]?delid=$key'>X<a>]</td></tr>";
            }
            echo "</TABLE>";
        }
        else echo "<p>No data</p>";
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<META HTTP-EQUIV="Expires" CONTENT="Fri, Jan 01 1900 00:00:00 GMT">
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache">
<META http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<META http-equiv="content-language" content="en">
<META name="author" content="Barand">
<META name="generator" content="PHPEd 3.1">
<META name="revisit-after" content="15 days">
<title>Sample</title>
</head>
<body>
<FORM  method="POST" action="<?php echo $_SERVER['PHP_SELF']?>">
<INPUT TYPE="HIDDEN"  name="userdata" value="1">
<?php
if (!empty($username))
     echo "<INPUT TYPE=\"HIDDEN\"  name=\"username\" value=\"$username\">";
?>
<TABLE style="background: #E0E0E0; border: solid 2pt #666666" >
<TR>
    <TD colspan='2' style="border-bottom: solid 1pt #666666; font-weight: bold; text-align: center">
    User data
    </TD>
</TR>
<TR>
    <TD>
    User name
    </TD>
    <TD>
        <INPUT TYPE="TEXT"  name="username" size="10" maxlength="10"
                value='<?php echo $username ?>'
                <?php echo  empty($username) ? '' : ' DISABLED ' ?> >
    </TD>
</TR>
<TR>
    <TD>
    First name
    </TD>
    <TD>
    <INPUT TYPE="TEXT"  name="firstname" size="20" maxlength="20" value='<?php echo $firstname ?>'>
    </TD>
</TR>
<TR>
    <TD>
    Last name
    </TD>
    <TD>
    <INPUT TYPE="TEXT"  name="lastname" size="20" maxlength="20" value='<?php echo $lastname ?>'><br>
    </TD>
    </TR>
<TR>
    <TD>
    Email address
    </TD>
    <TD>
    <INPUT TYPE="TEXT"  name="email" size="30" maxlength="30" value='<?php echo $email ?>'><br>
    </TD>
</TR>
<TR>
     <TD>
     &nbsp;
     </TD>
     <TD>
    <INPUT TYPE="SUBMIT"  value="Send data">
    <?php
    if (!empty($username))
         echo "<INPUT TYPE=\"BUTTON\"  value=\"Cancel\"   onClick=\"history.go(-1);\">";
    ?>

    </TD>
</TR>
</TABLE>
</FORM>

<?php
     # if we are not editing a record, list the data
     if (!isset($_GET['changeid'])) {
          listData($data);
     }
?>

</body>
</html>

